/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.server.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.ui.internal.server.wizard.ServerLocationWizardPage;

public abstract class AbstractServerLocationWizard
extends Wizard
implements INewWizard {
    private final ServerLocationWizardPage page;

    public AbstractServerLocationWizard(ServerLocationWizardPage page, String title) {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(title);
        this.setHelpAvailable(false);
        this.page = page;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String serverId = this.page.getServerId();
        final String serverName = this.page.getServerName();
        final String serverUrl = this.page.getServerUrl();
        final String username = this.page.getUsername();
        final String password = this.page.getPassword();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                monitor.beginTask("Saving '" + serverId + "'", 1);
                try {
                    try {
                        AbstractServerLocationWizard.this.doFinish(serverId, serverName, serverUrl, username, password);
                    }
                    catch (Exception e) {
                        SonarLintCorePlugin.getDefault().error(e.getMessage(), (Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    protected abstract void doFinish(String var1, String var2, String var3, String var4, String var5);
}

